import 'package:flutter/material.dart';
import 'package:nb_utils/nb_utils.dart';

import '../../components/empty_error_state_widget.dart';
import '../../main.dart';
import '../../utils/app_configuration.dart';
import '../../utils/colors.dart';
import '../../utils/constant.dart';

class PaymentTypeFilter extends StatefulWidget {
  final List<PaymentSetting> paymentTypeList;

  PaymentTypeFilter({required this.paymentTypeList});

  @override
  _PaymentTypeFilterState createState() => _PaymentTypeFilterState();
}

class _PaymentTypeFilterState extends State<PaymentTypeFilter> {
  @override
  Widget build(BuildContext context) {
    if (widget.paymentTypeList.isEmpty)
      return NoDataWidget(
        title: languages.noPaymentMethodsFound,
        imageWidget: const EmptyStateWidget(),
      );

    return SingleChildScrollView(
      padding: const EdgeInsets.only(bottom: 80),
      child: Container(
        alignment: Alignment.topLeft,
        child: AnimatedWrap(
          spacing: 12,
          runSpacing: 12,
          slideConfiguration: sliderConfigurationGlobal,
          itemCount: widget.paymentTypeList.length,
          listAnimationType: ListAnimationType.FadeIn,
          fadeInConfiguration: FadeInConfiguration(duration: 2.seconds),
          itemBuilder: (context, index) {
            final PaymentSetting res = widget.paymentTypeList[index];

            return Container(
              width: context.width(),
              padding: const EdgeInsets.symmetric(horizontal: 16, vertical: 12),
              decoration: boxDecorationDefault(
                color: appStore.isDarkMode
                    ? res.isSelected
                        ? lightPrimaryColor
                        : context.cardColor
                    : res.isSelected
                        ? lightPrimaryColor
                        : context.cardColor,
                borderRadius: radius(8),
                border: Border.all(
                  color: appStore.isDarkMode ? Colors.white54 : lightPrimaryColor,
                ),
              ),
              child: Row(
                mainAxisSize: MainAxisSize.min,
                children: [
                  if (res.isSelected)
                    Container(
                      padding: const EdgeInsets.all(2),
                      margin: const EdgeInsets.only(right: 1),
                      child: Icon(
                        Icons.done,
                        size: 16,
                        color: context.primaryColor,
                      ),
                    ),
                  Text(
                    res.title.validate(),
                    style: primaryTextStyle(
                      color: appStore.isDarkMode
                          ? res.isSelected
                              ? context.primaryColor
                              : Colors.white54
                          : res.isSelected
                              ? context.primaryColor
                              : Colors.black,
                      size: 12,
                    ),
                  ),
                ],
              ),
            ).onTap(() {
              setState(() {
                res.isSelected = !res.isSelected;

                if (res.isSelected) {
                  filterStore.addToPaymentTypeList(
                    paymentTypeList: res.type.validate(),
                  );
                } else {
                  filterStore.removeFromPaymentTypeList(
                    paymentTypeList: res.type.validate(),
                  );
                }
              });
            });
          },
        ).paddingAll(16),
      ),
    );
  }
}