import 'package:handyman_provider_flutter/locale/base_language.dart';

class LanguageDe extends Languages {
  @override
  String planAboutToExpire(int days) => 'Your Plan Is About to Expire In $days Days';

  @override
  String get appName => 'Anbieter';

  @override
  String get provider => 'Anbieter';

  @override
  String get lblShowingOnly4Handyman => 'Nur 4 Handwerker zeigen';

  @override
  String get lblRecentlyOnlineHandyman => 'Kürzlich Online -Handwerker';

  @override
  String get lblStartDrive => 'Start Laufwerk';

  @override
  String get handyman => 'Heimwerker';

  @override
  String get signIn => 'Einloggen';

  @override
  String get signUp => 'Anmeldung';

  @override
  String get hintFirstNameTxt => 'Geben Sie Ihren Vornamen ein';

  @override
  String get hintLastNameTxt => 'Geben Sie Ihren Nachnamen ein';

  @override
  String get hintContactNumberTxt => 'Geben Sie Ihre Kontaktnummer ein';

  @override
  String get hintEmailAddressTxt => 'Geben sie ihre E-Mailadresse ein';

  @override
  String get hintUserNameTxt => 'Geben Sie Ihren Benutzernamen ein';

  @override
  String get hintReenterPasswordTxt => 'Kennwort erneut eingeben';

  @override
  String get confirm => 'Bestätigen Sie';

  @override
  String get forgotPassword => 'Passwort vergessen?';

  @override
  String get alreadyHaveAccountTxt => 'Sie haben bereits ein Konto';

  @override
  String get rememberMe => 'Erinnere dich an mich';

  @override
  String get forgotPasswordTitleTxt => 'Geben sie ihre E-Mailadresse ein';

  @override
  String get resetPassword => 'Passwort zurücksetzen';

  @override
  String get editProfile => 'Profil bearbeiten';

  @override
  String get saveChanges => 'Änderungen speichern';

  @override
  String get camera => 'Kamera';

  @override
  String get language => 'Sprachen';

  @override
  String get appTheme => 'App-Thema.';

  @override
  String get bookingHistory => 'Buchungsverlauf';

  @override
  String get logout => 'Ausloggen';

  @override
  String get afterLogoutTxt => 'Möchten Sie sich von der App abmelden? Sie können sich immer wieder angemeldet!';

  @override
  String get chooseTheme => 'Wählen Sie das App-Thema';

  @override
  String get selectCountry => 'Land auswählen';

  @override
  String get selectState => 'Staat wählen';

  @override
  String get selectCity => 'Stadt wählen';

  @override
  String get changePassword => 'Passwort ändern';

  @override
  String get passwordNotMatch => 'Passwort stimmt nicht überein';

  @override
  String get doNotHaveAccount => 'Ich habe kein Konto?';

  @override
  String get hintNewPasswordTxt => 'Neues Kennwort';

  @override
  String get hintOldPasswordTxt => 'Altes Passwort';

  @override
  String get review => 'Rezension';

  @override
  String get notification => 'Benachrichtigungen';

  @override
  String get accept => 'Annehmen';

  @override
  String get decline => 'Ablehnen';

  @override
  String get noDataFound => 'Keine Daten gefunden';

  @override
  String get pending => 'Ausstehend';

  @override
  String get darkMode => 'Dunkler Modus';

  @override
  String get lightMode => 'Lichtmodus';

  @override
  String get systemDefault => 'Systemmodus';

  @override
  String get confirmationRequestTxt => 'Möchten Sie diese Aktion sicher ausführen?';

  @override
  String get notAvailable => 'Nicht verfügbar';

  @override
  String get lblGallery => 'Galerie';

  @override
  String get cantLogin => 'kann nicht einloggen';

  @override
  String get pleaseContactAdmin => 'Bitte wenden Sie sich an den Administrator';

  @override
  String get lblOk => 'OK';

  @override
  String get paymentStatus => 'Zahlungsstatus';

  @override
  String get paymentMethod => 'Bezahlverfahren';

  @override
  String get hintAddress => 'Adresse eingeben';

  @override
  String get quantity => 'Menge';

  @override
  String get lblYes => 'Jawohl';

  @override
  String get lblNo => 'Nein';

  @override
  String get lblReason => 'Grund';

  @override
  String get lblSelectHandyman => 'Bitte wählen Sie Handwerker aus';

  @override
  String get lblAssign => 'Zuordnen';

  @override
  String get lblCall => 'Anruf';

  @override
  String get lblAssignHandyman => 'Handwerker zuweisen.';

  @override
  String get lblAssigned => 'Zugewiesen';

  @override
  String get viewAll => 'Alle ansehen';

  @override
  String get lblMonthlyRevenue => 'Monatliche Einnahmen';

  @override
  String get lblRevenue => 'Einnahmen';

  @override
  String get lblAddHandyman => 'Handwerker hinzufügen';

  @override
  String get lblBooking => 'Buchung';

  @override
  String get lblTotalBooking => 'Gesamtbuchungen';

  @override
  String get lblTotalService => 'Total Service.';

  @override
  String get lblTotalHandyman => 'Totaler Handwerker.';

  @override
  String get monthlyEarnings => 'Monatliches Einkommen';

  @override
  String get lblPayment => 'Zahlung';

  @override
  String get lblBookingID => 'Buchungs-ID.';

  @override
  String get lblPaymentID => 'Zahlungs-ID.';

  @override
  String get lblAmount => 'Betragen';

  @override
  String get hintAddService => 'Service hinzufügen';

  @override
  String get hintServiceName => 'Geben Sie den Service-Name ein';

  @override
  String get hintSelectCategory => 'Kategorie wählen';

  @override
  String get hintSelectType => 'Art auswählen';

  @override
  String get hintSelectStatus => 'Status auswählen';

  @override
  String get hintPrice => 'Preis';

  @override
  String get hintDiscount => 'Rabatt';

  @override
  String get hintDuration => 'Dauer';

  @override
  String get hintDescription => 'Beschreibung';

  @override
  String get hintSetAsFeature => 'Als Funktion einstellen';

  @override
  String get hintAdd => 'Hinzufügen';

  @override
  String get hintChooseImage => 'Wählen Sie das Bild';

  @override
  String get customer => 'Kunde';

  @override
  String get lblProfile => 'Profil';

  @override
  String get lblAllHandyman => 'Alles Handwerker';

  @override
  String get lblTime => 'Zeit';

  @override
  String get lblMyService => 'Meine Dienstleistungen';

  @override
  String get lblAllService => 'Alle service.';

  @override
  String get lblChat => 'Plaudern';

  @override
  String get selectAddress => 'Wählen Sie Serviceadressen';

  @override
  String get btnSave => 'Speichern';

  @override
  String get editAddress => 'Serviceadresse bearbeiten.';

  @override
  String get lblUpdate => 'Aktualisieren';

  @override
  String get lblEdit => 'Bearbeiten';

  @override
  String get lblDelete => 'Löschen';

  @override
  String get lblServiceAddress => 'Serviceadressen.';

  @override
  String get lblServices => 'Dienstleistungen';

  @override
  String get lblEditService => 'Service bearbeiten';

  @override
  String get selectImgNote => "HINWEIS: Sie können Bilder mit \ 'jpg \', \ 'png \', \ 'jpeg \'-Erweiterungen hochladen, und Sie können mehrere Bilder auswählen";

  @override
  String get lblDurationHr => 'Dauer: Stunden';

  @override
  String get lblDurationMin => 'Dauer: Minute.';

  @override
  String get lblWaitForAcceptReq => 'Bitte warten Sie auf Admin, um Ihre Anfrage anzunehmen';

  @override
  String get lblAddServiceAddress => 'Serviceadresse hinzufügen.';

  @override
  String get errorPasswordLength => 'Die Passwortlänge sollte mehr als sein';

  @override
  String get hintPassword => 'Passwort';

  @override
  String get hintRequired => 'Dieses Feld ist erforderlich';

  @override
  String get lblUnAuthorized => "Demo-Benutzer kann nicht für diese Aktion gewährt werden";

  @override
  String get btnVerifyId => "Überprüfen Sie Ihren ID.";

  @override
  String get confirmationUpload => 'Sind Sie sicher, dass Sie dieses Dokument hochladen?';

  @override
  String get toastSuccess => "Provider-Dokument hat erfolgreich gespeichert";

  @override
  String get lblSelectDoc => "Dokument auswählen";

  @override
  String get lblAddDoc => "Dokumente hinzufügen.";

  @override
  String get lblRateUs => "Bewerten Sie uns";

  @override
  String get lblTermsAndConditions => 'Allgemeine Geschäftsbedingungen';

  @override
  String get lblPrivacyPolicy => "Datenschutz-Bestimmungen";

  @override
  String get lblHelpAndSupport => 'Hilfe und Support';

  @override
  String get lblAbout => "Etwa";

  @override
  String get lblProviderType => "Kommissionstyp.";

  @override
  String get lblMyCommission => "Meine Kommission";

  @override
  String get lblTaxes => "Steuern";

  @override
  String get lblTaxName => "Steuertyp.";

  @override
  String get lblMyTax => "Meine steuer";

  @override
  String get lblLoginTitle => "Hallo wieder !";

  @override
  String get lblLoginSubtitle => "Willkommen zurück, Sie wurden schon lange vermisst";

  @override
  String get lblSignupTitle => "Hallo Benutzer!";

  @override
  String get lblSignupSubtitle => "Erstellen Sie Ihr Konto für bessere Erfahrung";

  @override
  String get lblSignup => "Anmeldung";

  @override
  String get lblUserType => "Benutzertyp";

  @override
  String get lblPurchaseCode => "Vollständiger Quellcode kaufen";

  @override
  String get lblRating => "Nennen";

  @override
  String get lblOff => "lblOff";

  @override
  String get lblHr => "Stunde";

  @override
  String get lblDate => "Datum";

  @override
  String get lblAboutHandyman => "Über Handwerker.";

  @override
  String get lblAboutCustomer => "Über den Kunden.";

  @override
  String get lblPaymentDetail => "Zahlungsdetails";

  @override
  String get lblId => "ICH WÜRDE";

  @override
  String get lblMethod => "Methode";

  @override
  String get lblStatus => "Status";

  @override
  String get lblPriceDetail => "Preisdetails";

  @override
  String get lblSubTotal => "Subsumme";

  @override
  String get lblTax => "Steuer";

  @override
  String get lblCoupon => "Coupon";

  @override
  String get lblTotalAmount => "Gesamtmenge";

  @override
  String get lblOnBasisOf => "Auf der Grundlage von";

  @override
  String get lblCheckStatus => "Status überprüfen";

  @override
  String get lblCancel => "Stornieren";

  @override
  String get lblUnreadNotification => "Ungelesene Benachrichtigung";

  @override
  String get lblMarkAllAsRead => "Markiere alle als gelesen";

  @override
  String get lblCloseAppMsg => "Drücken Sie erneut, um die App zu verlassen";

  @override
  String get lblAddress => "Adresse";

  @override
  String get lblType => "Art";

  @override
  String get lblHandymanType => "Handwerkertyp.";

  @override
  String get lblFixed => "Fest";

  @override
  String get lblHello => "Hallo";

  @override
  String get lblWelcomeBack => "Willkommen zurück!";

  @override
  String get lblNoReviewYet => "Noch keine Bewertung";

  @override
  String get lblWaitingForResponse => "Auf Rückantwort warten";

  @override
  String get lblConfirmPayment => "Bestätige Zahlung";

  @override
  String get lblDelivered => "Geliefert";

  @override
  String get lblDay => "Tag";

  @override
  String get lblYear => "Jahr";

  @override
  String get lblExperience => "Erfahrung";

  @override
  String get lblOf => "(s) von";

  @override
  String get lblSelectAddress => "Adresse auswählen";

  @override
  String get lblOppS => "Opps.";

  @override
  String get lblNoInternet => "Etwas stimmt nicht mit Ihrer Verbindung, bitte versuchen Sie es erneut.";

  @override
  String get lblRetry => "WIEDERHOLEN";

  @override
  String get lblServiceStatus => "Service Status";

  @override
  String get lblMemberSince => "Mitglied seit";

  @override
  String get lblDeleteAddress => "Adresse löschen";

  @override
  String get lblDeleteAddressMsg => 'Möchten Sie diese Adresse löschen?';

  @override
  String get lblChoosePaymentMethod => "Zahlungsart auswählen";

  @override
  String get lblNoPayments => "Keine Zahlungen";

  @override
  String lblPayWith(String title) => 'Möchten Sie mit $title bezahlen?';

  @override
  String get lblProceed => "Vorgehen";

  @override
  String get lblPricingPlan => "Preisplan";

  @override
  String get lblSelectPlan => 'Bereit anzufangen?';

  @override
  String get lblMakePayment => "Bezahlen";

  @override
  String get lblRestore => "Wiederherstellen";

  @override
  String get lblForceDelete => "Delete zwingen.";

  @override
  String get lblActivated => "Aktiviert";

  @override
  String get lblDeactivated => "Deaktiviert";

  @override
  String get lblNoDescriptionAvailable => "Keine Beschreibung verfügbar";

  @override
  String get lblFAQs => "FAQs";

  @override
  String get lblGetDirection => "Richtungsrichtung";

  @override
  String get lblDeleteTitle => "Oh nein, du gehst!";

  @override
  String get lblDeleteSubTitle => "Möchten Sie sich abmelden?";

  @override
  String get lblUpcomingServices => "Bevorstehende Dienstleistungen.";

  @override
  String get lblTodayServices => "Heutige Dienstleistungen";

  @override
  String get lblPlanExpired => "Opps! Plan abgelaufen";

  @override
  String get lblPlanSubTitle => "Ihr vorheriger Plan ist abgelaufen";

  @override
  String get btnTxtBuyNow => "Kaufe jetzt";

  @override
  String get lblChooseYourPlan => "Wählen Sie Ihren Plan";

  @override
  String get lblRenewSubTitle => "Kaufen Sie einen neuen Plan, um neue Servicebuchungen zu erhalten";

  @override
  String get lblReminder => "Erinnerung";

  @override
  String get lblRenew => "Erneuern";

  @override
  String get lblCurrentPlan => "Derzeitiger Plan";

  @override
  String get lblValidTill => "Gültig bis";

  @override
  String get lblSearchHere => "Suche hier...";

  @override
  String get lblEarningList => "Ertragsliste";

  @override
  String get lblSubscriptionTitle => 'Möchten Sie den aktuellen Plan kündigen?';

  @override
  String get lblPlan => "Planen";

  @override
  String get lblCancelPlan => "Plan abbrechen";

  @override
  String get lblSubscriptionHistory => "Abonnementverlauf";

  @override
  String get lblTrashHandyman => "Handwerker ist erfolgreich müll";

  @override
  String get lblPlsSelectAddress => "Bitte ausgewählte Adresse.";

  @override
  String get lblPlsSelectCategory => "Bitte ausgewählte Kategorie";

  @override
  String get lblEnterHours => "Geben Sie Stunden bis 24 Stunden ein";

  @override
  String get lblEnterMinute => "Geben Sie bis zu 60 Minuten ein";

  @override
  String get lblSelectSubCategory => "Wählen Sie Unterkategorie";

  @override
  String get lblServiceProof => "Service -Beweis";

  @override
  String get lblTitle => "Titel";

  @override
  String get lblAddImage => "Bild hinzufügen";

  @override
  String get lblSubmit => "Einreichen";

  @override
  String get lblWalletHistory => "Brieftaschengeschichte";

  @override
  String get lblServiceRatings => "Servicemittel";

  @override
  String get lblWallet => "Brieftasche";

  @override
  String get lblSelectCommission => 'Wählen Sie Provision';

  @override
  String get lblIAgree => "Brieftasche";

  @override
  String get lblTermsOfService => "Wählen Sie Benutzerart";

  @override
  String get lblLoginAgain => "Ich stimme dem zu";

  @override
  String get lblTermCondition => "Nutzungsbedingungen";

  @override
  String get lblServiceTotalTime => "Service Gesamtzeit";

  @override
  String get lblHelpLineNum => "Helpline -Nummer";

  @override
  String get lblReasonCancelling => "Grund für die Absage dieser Buchung";

  @override
  String get lblReasonRejecting => "Grund für die Ablehnung dieser Buchung";

  @override
  String get lblFailed => "Grund, warum diese Buchung gescheitert ist";

  @override
  String get lblDesignation => "Bezeichnung";

  @override
  String get lblHandymanIsOffline => "Handwerker ist offline";

  @override
  String get lblDoYouWantToRestore => "Möchten Sie wiederherstellen?";

  @override
  String get lblDoYouWantToDeleteForcefully => "Möchten Sie zwangsläufig löschen?";

  @override
  String get lblDoYouWantToDelete => "Möchten Sie löschen?";

  @override
  String get lblPleaseEnterMobileNumber => "Bitte geben Sie Handynummer ein";

  @override
  String get lblDangerZone => "Gefahrenzone";

  @override
  String get lblDeleteAccount => "Konto löschen";

  @override
  String get lblDeleteAccountConformation => "Ihr Konto wird dauerhaft gelöscht. Ihre Daten werden nicht wieder wiederhergestellt.";

  @override
  String get lblUnderMaintenance => "Wird gewartet...";

  @override
  String get lblCatchUpAfterAWhile => "Nach einer Weile aufholen";

  @override
  String get lblRecheck => "Überprüfung";

  @override
  String get lblTrialFor => "Versuch für";

  @override
  String get lblDays => "Tage";

  @override
  String get lblFreeTrial => "Kostenlose Testphase";

  @override
  String get lblAtLeastOneImage => "Wählen Sie mindestens ein Bild";

  @override
  String get lblService => "Service";

  @override
  String get lblNewUpdate => "Neues Update";

  @override
  String get lblOptionalUpdateNotify => "Optionales Update Benachrichtigung";

  @override
  String get lblAnUpdateTo => "Ein Update zu";

  @override
  String get lblIsAvailableWouldYouLike => "ist verfügbar. Möchten sie updaten?";

  @override
  String lblAreYouSureYouWantToAssignThisServiceTo(String name) => "Do you want to assign this service to $name?";

  @override
  String get lblAreYouSureYouWantToAssignToYourself => 'Möchten Sie sich selbst zuweisen?';

  @override
  String get lblAssignToMyself => "Mir selbst zuweisen";

  @override
  String get lblFree => "unbezahlt";

  @override
  String get lblMyProvider => "Mein Anbieter";

  @override
  String get lblAvailableStatus => "Verfügbarer Status";

  @override
  String get lblYouAre => "Sie sind";

  @override
  String get lblEmailIsVerified => "E -Mail wird verifiziert";

  @override
  String get lblHelp => "Hilfe";

  @override
  String get lblAddYourCountryCode => "Fügen Sie Ihren Ländercode hinzu";

  @override
  String get lblRegistered => "Eingetragen";

  @override
  String get lblRequiredAfterCountryCode => "nach Ländercode erforderlich";

  @override
  String get lblExtraCharges => "Extrakosten";

  @override
  String get lblAddExtraCharges => "Fügen Sie zusätzliche Gebühren hinzu";

  @override
  String get lblCompleted => 'Vollständig';

  @override
  String get lblAddExtraChargesDetail => "Fügen Sie Ladungsdetails hinzu";

  @override
  String get lblEnterExtraChargesDetail => "Geben Sie das Detail der Gebühren ein";

  @override
  String get lblTotalCharges => "Gesamtkosten";

  @override
  String get lblSuccessFullyAddExtraCharges => "Fügen Sie erfolgreich zusätzliche Gebühren hinzu";

  @override
  String get lblChargeName => "Ladungsname";

  @override
  String get lblPrice => "Preis";

  @override
  String get lblEnterAmount => "Menge eingeben";

  @override
  String get lblHourly => "Stündlich";

  @override
  String get noBookingTitle => "Keine Buchung gefunden";

  @override
  String get noBookingSubTitle => "Sieht so aus, als hätten Ihr Kunde Ihre Dienste noch nicht gebucht";

  @override
  String get noNotificationTitle => "Es sieht hier etwas leer aus";

  @override
  String get noNotificationSubTitle => "Wir werden Sie benachrichtigen, sobald wir etwas für Sie haben";

  @override
  String get noHandymanAvailable => "Handwerker nicht verfügbar";

  @override
  String get noHandymanYet => "Noch kein Handwerker";

  @override
  String get noHandymanSubTitle => "Bitte überprüfen Sie zuerst aktiv und handwerklich aktiv";

  @override
  String get noServiceFound => "Kein Service gefunden";

  @override
  String get noServiceSubTitle => "Beeil dich! Fügen Sie Dienste für den Kunden hinzu und erweitern Sie Ihre Arbeit";

  @override
  String get noServiceAddressTitle => "Serviceadresse nicht gefunden";

  @override
  String get noServiceAddressSubTitle => "Fügen Sie zuerst Ihre Serviceadresse hinzu, dann wird sie hier angezeigt";

  @override
  String get noSubscriptionPlan => "Kein Abonnementplan hier";

  @override
  String get noSubscriptionFound => "Kein Abonnement gefunden";

  @override
  String get noSubscriptionSubTitle => "Sie haben kein Abonnement abonniert";

  @override
  String get noTexesFound => "Keine Texes gefunden";

  @override
  String get noWalletHistoryTitle => "Keine Brieftaschengeschichte gefunden";

  @override
  String get noWalletHistorySubTitle => "Du hast noch nicht überdacht. Reiten Sie Ihre Brieftasche hier auf, um hier zu sehen";

  @override
  String get noExtraChargesHere => "Keine zusätzlichen Gebühren hier";

  @override
  String get getYourFirstReview => "Holen Sie sich Ihre erste Bewertung";

  @override
  String get ratingViewAllSubtitle => "Erfassen Sie hochwertige Produktbewertungen für Ihren Service";

  @override
  String get noDocumentFound => "Kein Dokument gefunden";

  @override
  String get noDocumentSubTitle => "Kein Dokument zur Überprüfung";

  @override
  String get noConversation => "Kein Gespräch";

  @override
  String get jobRequestList => 'Jobanfrageliste';

  @override
  String get bidList => 'Angebotsliste';

  @override
  String get bid => 'Gebot';

  @override
  String get postJobTitle => 'Post -Berufsbezeichnung';

  @override
  String get postJobDescription => 'Post -Job -Beschreibung';

  @override
  String get jobPrice => 'Arbeitspreis';

  @override
  String get estimatedPrice => 'Schätzpreis';

  @override
  String get assignedProvider => 'Zugewiesener Anbieter';

  @override
  String get giveYourEstimatePriceHere => 'Geben Sie hier Ihren Schätzpreis an';

  @override
  String get pleaseEnterValidBidPrice => 'Bitte geben Sie den gültigen Gebotspreis ein';

  @override
  String get yourPriceShouldNotBeLessThan => 'Ihr Preis sollte nicht geringer sein als';

  @override
  String get enterBidPrice => 'Geben Sie den Gebotspreis ein';

  @override
  String get myBid => 'Mein Angebot';

  @override
  String get inputMustBeNumberOrDigit => 'Die Eingabe muss Anzahl oder Ziffer sein';

  @override
  String get requiredAfterCountryCode => 'nach Ländercode erforderlich';

  @override
  String get thisSlotIsNotAvailable => 'Dieser Slot ist nicht verfügbar';

  @override
  String get notes => 'Anmerkungen:';

  @override
  String get timeSlotsNotes1 => 'Zeitfenster sind nur für Anbieter.';

  @override
  String get timeSlotsNotes2 => 'Sie können Zeitfensterverfügbarkeit für jeden Dienst festlegen.';

  @override
  String get timeSlotsNotes3 => 'Der Kunde kann die Zeitfenster nur sehen, wenn Sie diese in einem bestimmten Service aktivieren.';

  @override
  String get noSlotsAvailable => 'Keine Slots verfügbar';

  @override
  String get timeSlots => 'Zeitfenster';

  @override
  String get selectYourDay => 'Wählen Sie Ihren Tag';

  @override
  String get chooseTime => 'Wählen Sie Zeit';

  @override
  String get copyTo => 'Kopieren nach';

  @override
  String get pleaseWaitWhileWeChangeTheStatus => 'Bitte warten Sie, während wir den Status ändern';

  @override
  String get myTimeSlots => 'Meine Zeitfenster';

  @override
  String get day => 'Tag';

  @override
  String get pleaseSelectServiceAddresses => 'Bitte wählen Sie Serviceadressen';

  @override
  String get pleaseSelectImages => 'Bitte wählen Sie Bilder aus';

  @override
  String get timeSlotAvailable => 'Zeitfenster verfügbar';

  @override
  String get doesThisServicesContainsTimeslot => 'Enthält diese Dienste ein Zeitfenster?';

  @override
  String get pleaseEnterTheDefaultTimeslotsFirst => 'Bitte geben Sie zuerst die Standard -Timeslots ein';

  @override
  String get chooseAction => 'Wähle eine Aktion';

  @override
  String get chooseImage => 'Wählen Sie Bild';

  @override
  String get removeImage => 'Entferne Bild';

  @override
  String get availableAt => 'Verfügbarer Standort';

  @override
  String get clearChat => 'Chat löschen';

  @override
  String get internetNotAvailable => 'Ihr Internet scheint offline zu sein';

  @override
  String get pleaseTryAgain => 'Bitte versuche es erneut';

  @override
  String get somethingWentWrong => 'Etwas ist schief gelaufen';

  @override
  String get upcomingBookings => 'Begleite Buchungen';

  @override
  String get postJob => 'Postjob';

  @override
  String get categoryBasedPackage => 'Kategoriebasiertes Paket';

  @override
  String get subTitleOfSelectService => 'Mit der Funktion können Sie einzelne oder mehrere Dienste aus einer einzelnen Kategorie auswählen';

  @override
  String get enabled => 'Ermöglicht';

  @override
  String get disabled => 'Behinderte';

  @override
  String get doYouWantTo => 'Möchten Sie';

  @override
  String get enable => 'ermöglichen';

  @override
  String get disable => 'deaktivieren';

  @override
  String get package => 'Paket';

  @override
  String get packages => 'Pakete';

  @override
  String get packageService => 'Paketservice';

  @override
  String get confirmationRemovePackage => 'Möchten Sie diesen Dienst aus dem Paket entfernen?';

  @override
  String get packageName => 'Paketnamen';

  @override
  String get selectService => 'Wählen Sie Service';

  @override
  String get packageDescription => 'Paketbeschreibung';

  @override
  String get packagePrice => 'Paketpreis';

  @override
  String get startDate => 'Anfangsdatum';

  @override
  String get endDate => 'Endtermin';

  @override
  String get pleaseSelectService => 'Bitte wählen Sie Service';

  @override
  String get pleaseEnterTheEndDate => 'Bitte geben Sie das Enddatum ein';

  @override
  String get editPackage => 'Paket bearbeiten';

  @override
  String get addPackage => 'Paket hinzufügen';

  @override
  String get areYouSureWantToDeleteThe => 'Sind Sie sicher das löschen';

  @override
  String get packageNotAvailable => 'Paket nicht verfügbar';

  @override
  String get includedInThisPackage => 'In diesem Paket enthalten';

  @override
  String get packageServicesWillAppearHere => 'Paketdienste werden hier angezeigt';

  @override
  String get showingFixPriceServices => 'Fixpreisdienste anzeigen (ausgeschlossen stündliche Dienstleistungen)';

  @override
  String get pleaseSelectTheCategory => 'Bitte wählen Sie die Kategorie aus';

  @override
  String get lblInvalidTransaction => 'Ungültige Transaktion';

  @override
  String get youWillGetTheseServicesWithThisPackage => 'Sie erhalten diese Dienste mit diesem Paket';

  @override
  String get lblSearchFullAddress => 'Tam Adresi Arayın';

  @override
  String get lblPleaseSelectCity => 'Lütfen şehri seçin';

  @override
  String get lblChooseOneImage => 'Bir görüntüyü seçin';

  @override
  String get lblNoTransactionFound => 'İşlem bulunamadı';

  @override
  String get lblSubTitleNoTransaction => 'Henüz tarihinizde hiçbir şey bulunamadı. Önce hizmetleri tamamlayın ve sonra ödeme alın';

  @override
  String get lblCheckOutWithCinetPay => 'CinetPay ile ödeme';

  @override
  String get yourPaymentFailedPleaseTryAgain => 'Ödemeniz başarısız oldu lütfen tekrar deneyin';

  @override
  String get yourPaymentHasBeenMadeSuccessfully => 'Ödemeniz başarıyla yapıldı';

  @override
  String get lblTransactionFailed => 'İşlem başarısız';

  @override
  String get lblTransactionCancelled => 'İşlem iptal edildi';

  @override
  String get lblStripeTestCredential => 'Test kimlik bilgisi 500\'den fazla ödeme yapamaz';

  @override
  String get lblSuccessFullyActivated => 'başarıyla etkinleştirildi';

  @override
  String get lblNoTaxesFound => 'Texes bulunamadı';

  @override
  String get lblConfirmationForDeleteMsg => 'Möchten Sie die Nachricht löschen?';

  @override
  String get lblImage => 'İmaj';

  @override
  String get lblVideo => 'Video';

  @override
  String get lblAudio => 'Ses';

  @override
  String get lblMessage => 'İleti';

  @override
  String get chatCleared => 'Sohbet temizlendi';

  @override
  String get lblNoEarningFound => 'Kazanma bulunamadı';

  @override
  String get lblNoUserFound => 'Kullanıcı bulunamadı';

  @override
  String get lblTokenExpired => 'Token süresi doldu';

  @override
  String get lblFailedToLoadPredictions => 'Tahminleri yükleyemedi';

  @override
  String get personalInfo => 'Persönliche Informationen';

  @override
  String get essentialSkills => 'Essenzielle Fähigkeiten';

  @override
  String get knownLanguages => 'Bekannte Sprachen';

  @override
  String get addEssentialSkill => 'Wesentliche Fähigkeiten hinzufügen';

  @override
  String get addKnownLanguage => 'Fügen Sie die bekannte Sprache hinzu';

  @override
  String get authorBy => 'Autor von';

  @override
  String get views => 'Ansichten';

  @override
  String get deleteBlogTitle => 'Möchten Sie diesen Blog löschen?';

  @override
  String get enterBlogTitle => 'Geben Sie Ihren Blog -Titel ein';

  @override
  String get updateBlog => 'Update Blog';

  @override
  String get addBlog => 'Blog hinzufügen';

  @override
  String get blogs => 'Blogs';

  @override
  String get noBlogsFound => 'Keine Blogs gefunden';

  @override
  String get aboutYou => 'Über dich';

  @override
  String get pleaseAddKnownLanguage => 'Bitte fügen Sie die bekannte Sprache hinzu';

  @override
  String get pleaseAddEssentialSkill => 'Bitte fügen Sie wichtige Fähigkeiten hinzu';

  @override
  String get published => 'Veröffentlicht';

  @override
  String get clearChatMessage => 'Möchten Sie diesen Chat löschen?';

  @override
  String get all => 'Alle';

  @override
  String get accepted => 'Akzeptiert';

  @override
  String get onGoing => 'Beim Gehen';

  @override
  String get inProgress => 'Im Gange';

  @override
  String get hold => 'Halten';

  @override
  String get cancelled => 'Abgesagt';

  @override
  String get rejected => 'Abgelehnt';

  @override
  String get failed => 'Fehlgeschlagen';

  @override
  String get completed => 'Vollendet';

  @override
  String get pendingApproval => 'Ausstehende Genehmigung';

  @override
  String get waiting => 'Warten';

  @override
  String get paid => 'Bezahlt';

  @override
  String get advancePaid => 'Vorab bezahlt';

  @override
  String get advancePayAmountPer => 'Vorauszahlungsbetrag (%)';

  @override
  String get enablePrePayment => 'Vorauszahlung aktivieren';

  @override
  String get enablePrePaymentMessage => 'Auf diese Weise kann der Service im Voraus bezahlt werden';

  @override
  String get invalidInput => 'Ungültige Eingabe';

  @override
  String get remainingAmount => 'Restbetrag';

  @override
  String get advancePayment => 'Vorauszahlung';

  @override
  String get valueConditionMessage => 'Der Wert sollte in 0 bis 99 sein';

  @override
  String get withExtraAndAdvanceCharge => 'Mit zusätzlicher Gebühr und Vorauszahlung';

  @override
  String get withExtraCharge => 'Mit zusätzlicher Gebühr';

  @override
  String get min => 'Mindest';

  @override
  String get hour => 'Stunde';

  @override
  String get lblChangeCountry => "Land ändern";

  @override
  String get lblExample => "Beispiel";

  @override
  String get active => 'Aktiv';

  @override
  String get inactive => 'Inaktiv';

  @override
  String get use24HourFormat => '24-Stunden-Format verwenden?';

  @override
  String get successfullyActivated => 'wird erfolgreich aktiviert';

  @override
  String get providerHome => 'Anbieter nach Hause';

  @override
  String get handymanHome => 'Handwerker nach Hause';

  @override
  String get home => 'Heim';

  @override
  String get selectPlanSubTitle => 'Wählen Sie einen Plan, der auf Ihre Bedürfnisse zugeschnitten ist';

  @override
  String get userRole => 'Benutzer-Rolle';

  @override
  String get paymentHistory => 'Zahlungshistorie';

  @override
  String get theService => 'der Service';

  @override
  String get selectDuration => 'Wählen Sie Dauer';

  @override
  String get thisServiceMayTake => 'Dieser Service kann dauern';

  @override
  String get priceAmountValidationMessage => 'Der Preisbetrag sollte verstreut sein als 0';

  @override
  String get lblFeatureBlog => 'Dies ist Blog';

  @override
  String get changePasswordTitle => 'Ihr neues Passwort muss sich vom vorherigen gebrauchten Passwort unterscheiden';

  @override
  String get forgotPasswordSubtitle => 'Ein Link zum Zurücksetzen des Kennworts wird an die oben eingegebene E -Mail -Adresse gesendet';

  @override
  String get badRequest => '400: Schlechte Anfrage';

  @override
  String get forbidden => '403 Verboten';

  @override
  String get pageNotFound => '404 Seite nicht gefunden';

  @override
  String get tooManyRequests => '429: Zu viele Anfragen';

  @override
  String get internalServerError => '500: Interner Serverfehler';

  @override
  String get badGateway => '502 Bad Gateway';

  @override
  String get serviceUnavailable => '503 Dienst nicht verfügbar';

  @override
  String get gatewayTimeout => '504: Gateway Timeout';

  @override
  String get requested => 'Angefordert';

  @override
  String get assigned => 'Zugewiesen';

  @override
  String get reload => 'Neu laden';

  @override
  String get noConversationSubTitle => 'Sie haben noch kein Gespräch geführt';

  @override
  String get noServiceAccordingToCoordinates => 'Konnte kein Ergebnis für die angegebene Adresse oder Koordinaten finden';

  @override
  String get isNotValid => 'ist ungültig';

  @override
  String get unlimited => 'Unbegrenzt';

  @override
  String get upTo => 'bis zu';

  @override
  String get amountToBeReceived => 'Zu empfangen werden';

  @override
  String get yourCashPaymentForBookingId => 'Ihre Barzahlung für die';

  @override
  String get isAcceptedAsOn => 'wird als auf akzeptiert';

  @override
  String get sendCashToProvider => 'Senden Sie Bargeld an den Anbieter';

  @override
  String get sendCashToAdmin => 'Senden Sie Bargeld an Administrator';

  @override
  String get cashPaymentApproval => 'Bargeldgenehmigung';

  @override
  String get approvedByHandyman => 'Genehmigt von Handyman';

  @override
  String get sentToProvider => 'An den Anbieter gesendet';

  @override
  String get pendingByProvider => 'Vom Anbieter ausstehend';

  @override
  String get approvedByProvider => 'Vom Anbieter genehmigt';

  @override
  String get pendingByAdmin => 'Ausstehend von Admin';

  @override
  String get approvedByAdmin => 'Genehmigt durch admin';

  @override
  String get sentToAdmin => 'An Admin gesendet';

  @override
  String get ofTransfer => 'Übertragung';

  @override
  String get refNumber => 'Ref. Nummer';

  @override
  String get todaySEarning => 'Das heutige Verdiener';

  @override
  String get cash => 'Kasse';

  @override
  String get bank => 'Bank';

  @override
  String get handymanApprovedTheRequest => 'Handwerker genehmigte die Anfrage';

  @override
  String get requestSentToTheProvider => 'Anfrage an den Anbieter gesendet';

  @override
  String get requestSentToTheAdmin => 'Anfrage an den Administrator gesendet';

  @override
  String get requestPendingWithTheProvider => 'Anfragen anhängig beim Anbieter';

  @override
  String get providerApprovedTheRequest => 'Der Anbieter genehmigte die Anfrage';

  @override
  String get requestPendingWithTheAdmin => 'Anfrage anhängig mit dem Administrator';

  @override
  String get adminApprovedTheRequest => 'Admin genehmigte die Anfrage';

  @override
  String get today => 'Heute';

  @override
  String get yesterday => 'Gestern';

  @override
  String get customDate => 'Benutzerdefinierte Datum';

  @override
  String get totalCash => 'Gesamter Kassenbestand';

  @override
  String get tomorrow => 'Morgen';

  @override
  String get cashList => 'Kassenliste';

  @override
  String get sortBy => 'Sortiere nach';

  @override
  String get noPaymentsFounds => 'Keine Zahlungen gefunden';

  @override
  String get cashBalance => 'Barguthaben';

  @override
  String get close => 'Schließen';

  @override
  String get retryPaymentDetails => 'Zahlungsdetails wiederholen';

  @override
  String get totalAmountToPay => 'Gesamtbetrag zu zahlen';

  @override
  String get from => 'Aus';

  @override
  String get booking => 'Buchung';

  @override
  String get choosePaymentMethod => 'Zahlungsart auswählen';

  @override
  String get sendToAdmin => 'An admin senden';

  @override
  String get sendToProvider => 'An den Anbieter senden';

  @override
  String get detailsOfTheBank => 'Details der Bank';

  @override
  String get selectABankTransferMoneyAndEnterTheReferenceIDInTheTextFieldBelow => 'Wählen Sie eine Bank aus, übertragen Sie Geld und geben Sie die Referenz -ID im folgenden Textfeld ein.';

  @override
  String get noBanksAvailable => 'Keine Banken verfügbar';

  @override
  String get chooseCashOrContactAdminForBankInformation => 'Wählen Sie Bargeld oder Kontaktanwalt für Bankinformationen';

  @override
  String get bankName => 'Bank Name';

  @override
  String get accountNumber => 'Accountnummer';

  @override
  String get iFSCCode => 'IFSC -Code';

  @override
  String get bankAddress => 'Bankadresse';

  @override
  String get pleaseWaitWhileWeLoadBankDetails => 'Bitte warten Sie, während wir Bankdaten laden ...';

  @override
  String get cashPaymentConfirmation => 'Bargeld Zahlungsbestätigung';

  @override
  String get remark => 'Anmerkung';

  @override
  String get pleaseWaitWhileWeLoadChatDetails => 'Bitte warten Sie, während wir Chat -Details laden';

  @override
  String get isNotAvailableForChat => 'ist nicht für den Chat verfügbar';

  @override
  String get connectWithFirebaseForChat => 'Connectez-vous avec Firebase pour le chat';

  @override
  String get admin => 'Administrator';

  @override
  String get cashStatus => 'Bargeldstatus';

  @override
  String get closeApp => 'Close App';

  @override
  String get youMustProvideValidCurrentPassword => 'Sie müssen ein gültiges aktuelles Passwort angeben';

  @override
  String get selectUserType => 'Wählen Sie Benutzerart';

  @override
  String get pleaseSelectCommission => 'Bitte Provision auswählen';

  @override
  String get copied => 'Kopiert';

  @override
  String get pleaseContactYourAdmin => 'Ihr Konto ist inaktiv. Bitte wenden Sie sich an den Systemadministrator.';

  @override
  String get search => 'Suchen';

  @override
  String get wouldYouLikeToAssignThisBooking => 'Möchten Sie diese Buchung zuweisen?';
@override
String get wouldYouLikeToAcceptThisBooking => 'Möchten Sie diese Buchung annehmen?';



  @override
  String get connect => 'Verbinden';

  @override
  String get youAreNotConnectedWithChatServer => 'Stellen Sie eine Verbindung zum Chat-Server her';

  @override
  String get tapBelowButtonToConnectWithOurChatServer =>
      'Sie sind nicht mit dem Chatserver verbunden. Tippen Sie auf die Schaltfläche unten, um eine Verbindung herzustellen und mit dem Chatten zu beginnen';

  // @override
  // String get youAreNotConnectedWithChatServer => 'Sie sind nicht mit dem Chat -Server verbunden';

  // @override
  // String get tapBelowButtonToConnectWithOurChatServer => 'Tippen Sie auf die Schaltfläche unten, um eine Verbindung mit unserem Chat -Server herzustellen';

  @override
  String get transactionId => 'Transaktions-ID';

  @override
  String get appliedTaxes => 'Angewandte Steuern';

  @override
  String get by => 'von';

  @override
  String get thisOrderWillBe => 'Diese Bestellung wird als abgeschlossen markiert. Möchten Sie fortfahren?';

  @override
  String get externalWallet => 'Außenbrieftasche';

  @override
  String get start => 'Start';

  @override
  String get digitalService => 'Digitaler Dienst';

  @override
  String get digitalServiceSwitchSubText => 'Digitale Dienstbuchung mit sofortigen Statusaktualisierungen in kurzer Prozess für direkte Interaktionen';

  @override
  String get filterAtLeastOneBookingStatusToast => 'Bitte stellen Sie sicher, dass Sie mindestens einen Buchungsstatus auswählen';

  @override
  String get apply => 'Anwenden';

  @override
  String get clearFilter => 'Klaren Filter';

  @override
  String get bookingStatus => 'Buchungsstatus';

  @override
  String get filterBy => 'Filtern nach';

  @override
  String get cinetpayIsnTSupportedByCurrencies => 'Cinetpay wird nicht von Ihren Währungen unterstützt';

  @override
  String get totalAmountShouldBeMoreThan => 'Gesamtbetrag sollte mehr als sein';

  @override
  String get totalAmountShouldBeLessThan => 'Die Gesamtmenge sollte geringer sein als';

  @override
  String get pleaseNoteThatAllServiceMarkedCompleted => 'Bitte beachten Sie, dass alle Service-Add-Ons als abgeschlossen markiert sind!';

  @override
  String get serviceVisitType => 'Servicebesuchstyp';

  @override
  String get thisServiceIsOnlineRemote => 'Dieser Service wird online/remote abgeschlossen sein.';

  @override
  String get visitOption => 'Besuchen Sie die Option';

  @override
  String get onSiteVisit => 'Vor-Ort Besuch';

  @override
  String get onlineRemoteService => 'Online-/Remote -Service';

  @override
  String get addOns => 'Add-Ons';

  @override
  String get serviceAddOns => 'Service-Add-Ons';

  @override
  String get writeHere => 'Hier schreiben';

  @override
  String get writeShortLineAbout => 'Schreiben Sie eine kurze Zeile darüber, warum mich wählen?';

  @override
  String get reasonsToChooseYour => 'Gründe, Ihren Service auszuwählen';

  @override
  String get addReasons => 'Gründe hinzufügen';

  @override
  String get addReason => 'Vernunft hinzufügen';

  @override
  String get writeReason => 'Vernunft schreiben';

  @override
  String get pleaseAddReason => 'Bitte fügen Sie Grund hinzu!';

  @override
  String get isAvailableGoTo => 'ist verfügbar. Gehen Sie zum Store ab und laden Sie die neue Version der App herunter.';

  @override
  String get later => 'Später';

  @override
  String get addonServices => 'Addon Services';

  @override
  String get paymentSuccess => 'Zahlungserfolg';

  @override
  String get redirectingToBookings => 'Umleitung zu Buchungen ..';

  @override
  String get transactionIsInProcess => 'Transaktion ist im Prozess ...';

  @override
  String get pleaseCheckThePayment => 'Bitte überprüfen Sie, ob die Zahlungsanfrage an Ihre Nummer gesendet wird';

  @override
  String get enterYourMsisdnHere => 'Geben Sie hier Ihre MSISDN ein';

  @override
  String get theTransactionIsStill =>
      'Die Transaktion verarbeitet immer noch und befindet sich im zweideutigen Zustand. Bitte führen Sie die Transaktionsanfrage durch, um den Transaktionsstatus abzurufen.';

  @override
  String get transactionIsSuccessful => 'Transaktion ist erfolgreich';

  @override
  String get incorrectPinHasBeen => 'Eine falsche PIN wurde eingegeben';

  @override
  String get theUserHasExceeded => 'Der Benutzer hat seine von der Brieftasche zugelassene Transaktionsgrenze überschritten';

  @override
  String get theAmountUserIs => 'Der Betrag, den der Benutzer überträgt, ist geringer als der zulässige Mindestbetrag';

  @override
  String get userDidnTEnterThePin => 'Der Benutzer hat die PIN nicht eingegeben';

  @override
  String get transactionInPendingState => 'Transaktion im ausstehenden Zustand. Bitte überprüfen Sie nach einiger Zeit';

  @override
  String get userWalletDoesNot => 'Benutzerbrieftasche hat nicht genug Geld, um den zahlenden Betrag abzudecken';

  @override
  String get theTransactionWasRefused => 'Die Transaktion wurde abgelehnt';

  @override
  String get thisIsAGeneric => 'Dies ist eine generische Ablehnung, die mehrere mögliche Ursachen hat';

  @override
  String get payeeIsAlreadyInitiated => 'Der Zahlungsempfänger ist bereits für die Abwanderung oder für die Barred oder nicht auf der Airtel Money -Plattform eingeleitet';

  @override
  String get theTransactionWasTimed => 'Die Transaktion wurde zeitlich festgelegt.';

  @override
  String get theTransactionWasNot => 'Die Transaktion wurde nicht gefunden.';

  @override
  String get xSignatureAndPayloadDid => 'X-Signatur und Nutzlast stimmten nicht überein';

  @override
  String get encryptionKeyHasBeen => 'Der Verschlüsselungsschlüssel wurde erfolgreich abgerufen';

  @override
  String get couldNotFetchEncryption => 'Konnte den Verschlüsselungsschlüssel nicht holen';

  @override
  String get transactionHasBeenExpired => 'Die Transaktion wurde abgelaufen';

  @override
  String get airtelMoneyPayment => 'Airtel -Geldzahlung';

  @override
  String get addonServiceName => 'Addon Service Name';

  @override
  String get editAddonService => 'Addon -Service bearbeiten';

  @override
  String get addAddonService => 'Addon -Service hinzufügen';

  @override
  String get noteYouCanUpload => "Hinweis: Sie können das Bild mit \ 'jpg \', \ 'png \', \ 'JPEG \' Extensions und nur ein Bild auswählen";

  @override
  String get oppsLooksLikeYou => 'Opps! Sieht so aus, als hätten Sie noch keine Add-On-Dienste hinzugefügt.';

  @override
  String get ambiguous => 'Mehrdeutig';

  @override
  String get success => 'Erfolg';

  @override
  String get incorrectPin => 'Falsche Pin';

  @override
  String get exceedsWithdrawalAmountLimitS => 'Überschreitet die Auszahlungsbetragsgrenze (en) / Abhebungsbetragsgrenze überschritten';

  @override
  String get invalidAmount => 'Ungültige Menge';

  @override
  String get transactionIdIsInvalid => 'Die Transaktions -ID ist ungültig';

  @override
  String get inProcess => 'In Bearbeitung';

  @override
  String get notEnoughBalance => 'Nicht genug Gleichgewicht';

  @override
  String get refused => 'Abgelehnt';

  @override
  String get doNotHonor => 'Nicht ehren';

  @override
  String get transactionNotPermittedTo => 'Transaktion nicht dem Zahlungsempfänger gestattet';

  @override
  String get transactionTimedOut => 'Transaktionszeitpunkt';

  @override
  String get transactionNotFound => 'Transaktion nicht gefunden';

  @override
  String get forBidden => 'Verboten';

  @override
  String get successfullyFetchedEncryptionKey => 'Erfolgreich abgerufene Verschlüsselungsschlüssel';

  @override
  String get errorWhileFetchingEncryption => 'Fehler beim Abrufen von Verschlüsselungsschlüssel';

  @override
  String get transactionExpired => 'Transaktion abgelaufen';

  @override
  String get pleaseSelectAService => 'Bitte wählen Sie einen Service aus';

  @override
  String get verifyEmail => 'E-Mail bestätigen';

  @override
  String get verified => 'Verifiziert';

  @override
  String get minRead => 'min lesen';

  @override
  String get loadingChats => 'Chats laden ...';

  @override
  String get monthly => 'Monatlich';

  @override
  String get mon => 'Mo';

  @override
  String get tue => 'Di';

  @override
  String get wed => 'Heiraten';

  @override
  String get thu => 'Do';

  @override
  String get fri => 'Fr';

  @override
  String get sat => 'Sa';

  @override
  String get sun => 'Sonne';

  @override
  String get jan => 'Jan';

  @override
  String get feb => 'Febr';

  @override
  String get mar => 'Beschädigen';

  @override
  String get apr => 'Apr';

  @override
  String get may => 'Mai';

  @override
  String get jun => 'Jun';

  @override
  String get july => 'Juli';

  @override
  String get aug => 'Aug';

  @override
  String get sept => 'Sept';

  @override
  String get oct => 'Okt';

  @override
  String get nov => 'Nov';

  @override
  String get dec => 'Dez';

  @override
  String get pushNotification => 'Push-Benachrichtigung';

  @override
  String get sentYouAMessage => 'Schickte dir eine Nachricht';

  @override
  String get deleteMessage => 'Nachricht löschen';

  @override
  String get removeThisFile => 'Entfernen Sie diese Datei';

  @override
  String get areYouSureWantToRemoveThisFile => 'Möchten Sie diese Datei wirklich entfernen?';

  @override
  String get sendMessage => 'Nachricht senden';

  @override
  String get handymanLocation => 'Handwerkerstandort';

  @override
  String get track => 'Schiene';

  @override
  String get trackHandymanLocation => 'Verfolgen Sie den Standort des Handwerkers';

  @override
  String get lastUpdatedAt => 'Zuletzt aktualisiert unter:';

  String get lblBankDetails => "Bankdaten";

  @override
  String get withdraw => "Zurückziehen";

  @override
  String get availableBalance => "Verfügbares Guthaben";

  @override
  String get withdrawRequest => "Antrag zurückziehen";

  @override
  String get chooseBank => "Bank auswählen";

  @override
  String get egCentralNationalBank => 'zB" Zentralbank"';

  @override
  String get addBank => "Bank hinzufügen";

  @override
  String get successful => 'Erfolgreich';

  @override
  String get yourWithdrawalRequestHasBeenSuccessfullySubmitted => 'Ihr Auszahlungsantrag wurde erfolgreich übermittelt.';

  @override
  String get done => "Erledigt";

  @override
  String get requestList => "Wunschliste";

  @override
  String get filter => 'Filter';

  @override
  String get reset => "zurücksetzen";

  @override
  String get bankList => "Bankliste";

  @override
  String get lbldefault => "Standard";

  @override
  String get setAsDefault => "Als Standard einstellen";

  @override
  String get branchName => "Zweigname";

  @override
  String get lblPleaseEnterAccountNumber => "Bitte geben Sie die Kontonummer ein";

  @override
  String get lblAccountNumberMustContainOnlyDigits => "Die Kontonummer darf nur Ziffern enthalten";

  @override
  String get lblAccountNumberMustBetween11And16Digits => "Die Kontonummer muss zwischen 11 und 16 Ziffern lang sein";

  @override
  String get noBankDataTitle => "Keine Bankdaten gefunden";

  @override
  String get noBankDataSubTitle => "Sie haben noch keine Bank hinzugefügt";

  @override
  String get eg3000 => 'zB" 3000"';

  @override
  String get pleaseAddLessThanOrEqualTo => "Bitte addieren Sie kleiner oder gleich";

  @override
  String get deleteBankTitle => 'Möchten Sie diese Bank wirklich löschen?';

  @override
  String get debit => 'Lastschrift';

  @override
  String get credit => 'Kredit';

  @override
  String get fullNameOnBankAccount => 'Vollständiger Name auf dem Bankkonto';

  @override
  String get updateYourLocation => 'Aktualisieren Sie Ihren Standort';

  @override
  String get lbHours => "Stunden";

  @override
  String get lbMinutes => "Minuten";

  @override
  String get handymanCommission => 'Handwerkerkommission';

  @override
  String get commission => 'Kommission';

  @override
  String get noCommissionTypeListFound => 'Keine Liste der Provisionsarten gefunden';

  @override
  String get typeName => 'Geben Sie den Namen ein';

  @override
  String get addHandymanCommission => 'Fügen Sie die Handwerkerprovision hinzu';

  @override
  String get editHandymanCommission => 'Bearbeiten Sie die Handwerkerkommission';

  @override
  String get enterValidCommissionValue => 'Geben Sie einen gültigen Provisionswert ein';

  @override
  String get percentage => 'Prozentsatz';

  @override
  String get selectStatus => 'Wählen Sie Status aus';

  @override
  String get youCanTUpdateDeleted => 'Sie können gelöschte Elemente nicht aktualisieren';

  @override
  String get thisCommissionHasBeen => 'Diese Provision wurde vom Administrator erstellt';

  @override
  String get copyMessage => 'Nachricht kopieren';

  @override
  String get transactions => 'Transaktionen';

  @override
  String get thisYear => 'Dieses Jahr';

  @override
  String get thisMonth => 'Diesen Monat';

  @override
  String get thisWeek => 'Diese Woche';

  @override
  String get providerList => 'Anbieterliste';

  @override
  String get walletBalance => 'Wallet-Guthaben';

  @override
  String get remainingPayout => 'Verbleibende Auszahlung';

  @override
  String get totalRevenue => 'Gesamtumsatz';

  @override
  String get totalActiveCount => 'Gesamtzahl der aktiven Aktivitäten:';

  @override
  String get completedBookings => 'Abgeschlossene Buchungen';

  @override
  String get pickAProviderYou => 'Wählen Sie einen Anbieter aus, mit dem Sie zusammenarbeiten möchten';

  @override
  String get selectedProvider => 'Ausgewählter Anbieter';

  @override
  String get youHavePermanentlyDenied => 'Sie haben die Standortberechtigung dauerhaft verweigert. Bitte erlauben Sie die Live-Standortverfolgung in Ihren Einstellungen';

  @override
  String get open => 'OFFEN';

  @override
  String get closed => 'GESCHLOSSEN';

  @override
  String get createBy => 'Erstellen von';

  @override
  String get repliedBy => 'Beantwortet von';

  @override
  String get closedBy => 'Geschlossen von';

  @override
  String get helpDesk => 'Helpdesk';

  @override
  String get addNew => 'Neu hinzufügen';

  @override
  String get queryYet => 'Noch eine Anfrage';

  @override
  String get toSubmitYourProblems => 'Um Ihre Probleme einzureichen, klicken Sie einfach auf die Schaltfläche „Hinzufügen“ und erläutern Sie Ihr Anliegen';

  @override
  String get noRecordsFoundFor => 'Keine Datensätze gefunden für';

  @override
  String get queries => 'Abfragen.';

  @override
  String get noActivityYet => 'Noch keine Aktivität';

  @override
  String get noRecordsFound => 'Keine Datensätze gefunden';

  @override
  String get reply => 'Antwort';

  @override
  String get eGDuringTheService => 'z.B. Während des Gottesdienstes wurden die Möbel versehentlich beschädigt.';

  @override
  String get doYouWantClosedThisQuery => 'Möchten Sie diese Abfrage schließen?';

  @override
  String get markAsClosed => 'Als geschlossen markieren';

  @override
  String get youCanMarkThis => 'Sie können dies als geschlossen markieren, wenn Sie mit unserer Antwort zufrieden sind';

  @override
  String get subject => 'Thema';

  @override
  String get eGDamagedFurniture => 'z.B. Beschädigte Möbel';

  @override
  String get closedOn => 'Geschlossen am:';

  @override
  String get on => 'An';

  @override
  String get showMessage => 'Nachricht anzeigen';

  @override
  String get viewDetail => 'Details anzeigen';

  @override
  String get serviceProofMediaUploadNote => 'Hinweis: Sie können Bilder mit der Erweiterung „JPG“, „PNG“ oder „JPEG“ hochladen und mehrere Bilder auswählen';

  @override
  String get uploadMedia => 'Medien hochladen';

  @override
  String get viewStatus => 'Status anzeigen';

  @override
  String get email => 'E-Mail:';

  @override
  String get at => 'bei';

  @override
  String get general => 'ALLGEMEIN';

  @override
  String get service => 'Dienst';
  @override
  String get other => 'ANDERE';

  @override
  String get setting => 'EINSTELLUNG';

  @override
  String get viewBreakdown => 'Aufschlüsselung anzeigen';

  @override
  String get totalAmount => 'Gesamtbetrag:';

  @override
  String get role => 'ROLLE';

  @override
  String get paymentBreakdown => 'Zahlungsaufschlüsselung';

  @override
  String get paymentType => 'Zahlungsart';

  @override
  String get dateRange => 'Datumsbereich';

  @override
  String get providerNotFound => 'Anbieter nicht gefunden';

  @override
  String get noPaymentMethodsFound => 'Keine Zahlungsmethoden gefunden';

  @override
  String get handymanNotFound => 'Handwerker nicht gefunden';

  @override
  String get selectStartDateEndDate => 'Wählen Sie Startdatum und Enddatum';

  @override
  String get customerNotFound => 'Kunde nicht gefunden';

  @override
  String get to => 'Zu';

  @override
  String get chooseYourDateRange => 'Wählen Sie Ihren Datumsbereich';

  @override
  String get advancedRefund => 'Erweiterte Rückerstattung';

  @override
  String get taxAmount => 'Steuerbetrag';

  @override
  String get lblReassign => 'Neu zuweisen';

  @override
  String get handymanPayoutList => 'Auszahlungsliste für Handwerker';

  @override
  String get earningDetails => 'Verdienstdetails';

  @override
  String get adminEarning => 'Admin-Verdienst';

  @override
  String get handymanName => 'Name des Handwerkers';

  @override
  String get totalEarning => 'Gesamtverdienst';

  @override
  String get myEarning => 'Mein Verdienst';

  @override
  String get handymanPayDue => 'Handwerker zahlen fällig';

  @override
  String get handymanPaidAmount => 'Vom Handwerker gezahlter Betrag';

  @override
  String get payout => 'Auszahlung';

  @override
  String get addHandymanPayout => 'Fügen Sie die Handwerkerauszahlung hinzu';

  @override
  String get selectMethod => 'Wählen Sie Methode';

  @override
  String get handymanEarning => 'Handwerker verdienen';

  @override
  String get handymanEarnings => 'Handwerkerverdienst';

  @override
  String get noPayoutFound => 'Keine Auszahlung gefunden';

  @override
  String get handymanEarningList => 'Verdienstliste für Handwerker';

  @override
  String get permissionDeniedUnableTo => 'Zugriff verweigert! Handwerker kann nicht bearbeitet werden';

  @override
  String get passwordLengthShouldBe => 'Die Länge des Passworts sollte 8 bis 12 Zeichen betragen.';

  @override
  String get promotionalBanners => 'Werbebanner';

  @override
  String get chooseAnyOnePayment => 'Wählen Sie zunächst eine beliebige Zahlungsmethode';

  @override
  String get thisBannerIsCurrently => 'Dieses Banner wird derzeit vom Administrator überprüft.';

  @override
  String get doYouWantToDeleteBanner => 'Möchten Sie dieses Banner löschen?';

  @override
  String get link => 'Link';

  @override
  String get youHaveAnInsufficient => 'Ihr Guthaben reicht nicht aus. Bitte wählen Sie eine andere Methode.';

  @override
  String get addPromotionalBanner => 'Werbebanner hinzufügen';

  @override
  String promoteYourBusinessBanners(String perDayAmount) => 'Bewerben Sie Ihre Geschäftsbanner in $perDayAmount/Tag.!';

  @override
  String get advertiseYourServicesEffectively => 'Bewerben Sie Ihre Dienstleistungen effektiv und steigern Sie noch heute das Engagement.';

  @override
  String get shortDescription => 'Kurzbeschreibung';

  @override
  String get eGHandymanTrustedService => 'z.B. Der vertrauenswürdige Handwerker-Service';

  @override
  String get chooseService => 'Wählen Sie Service';

  @override
  String get enterLink => 'Geben Sie den Link ein';

  @override
  String get eGHttpsWwwYourlinkCom => 'z.B. https://www.yourlink.com';

  @override
  String daysSelected(String totalDaysCount) => '$totalDaysCount ausgewählte Tage';

  @override
  String get promotionalBannerDetail => 'Details zum Werbebanner';

  @override
  String get promotionalBanner => 'Werbebanner';

  @override
  String promotionalBannerYet(String name) => 'Noch kein $name-Werbebanner';

  @override
  String get toSubmitYourBanner => 'Um Ihr Banner einzureichen, klicken Sie einfach auf die Schaltfläche „Hinzufügen“ und laden Sie Ihr Werbebanner hoch';

  @override
  String get canTFindRevenuecatProduct => 'RevenueCat-Produkt kann nicht gefunden werden';

  @override
  String get waitForAWhile => 'Warten Sie einen Moment, wir speichern Ihr Abonnement';

  @override
  String get reason => 'Grund:';

  @override
  String get type => 'Typ:';

  @override
  String noRecordsFoundForBanner(String status) => 'Für $status-Werbebanner wurden keine Datensätze gefunden';

  @override
  String get note => 'Notiz:';

  @override
  String get thisServiceIsCurrently => 'Dieser Dienst wird derzeit vom Administrator überprüft.';

  @override
  String get approved => 'Genehmigt';

  @override
  String get noPromotionalBannerYet => 'Noch kein Werbebanner';

  @override
  String get pay => 'Zahlen';

  @override
  String get selecteDateNote => 'Dieses Banner wird Benutzern vom {startDate} bis zum {endDate} angezeigt.';

  @override
  String get doWantToDelete => 'Möchten Sie diesen Dienst löschen?';

  @override
  String get razorPay => "RazorPay";

  @override
  String get payPal => "PayPal";

  @override
  String get stripe => "Stripe";

  @override
  String get payStack => "PayStack";

  @override
  String get flutterWave => "FlutterWave";

  @override
  String get wallet => "Brieftasche";

  @override
  String get paytm => "Paytm";

  @override
  String get airtelMoney => "Airtel Geld";

  @override
  String get cinet => "Cinet";

  @override
  String get midtrans => "Midtrans";

  @override
  String get sadadPayment => "Sadad";

  @override
  String get phonePe => "PhonePe";

  @override
  String get inAppPurchase => "In-App-Kauf";

  @override
  String get pix => "Pix";

  @override
  String get chooseWithdrawalMethod => "Wählen Sie die Auszahlungsmethode";

  @override
  String get servicesDelivered => "Servicios entregados";

  @override
  String get selectServiceZones => 'Servicezonen auswählen';

  @override
  String get selectZones => 'Zonen auswählen';

  @override
  String get plzSelectOneZone => 'Bitte wählen Sie die Servicezone';
  
  @override
  String get lblNext => 'Nächste';

  @override
  String get uploadDocuments => 'Dokumente hochladen';

  @override
  String get uploadRequiredDocuments => 'Erforderliche Dokumente hochladen';

  @override
  String get pleaseUploadTheFollowing => 'Bitte laden Sie zur Überprüfung die folgenden Dokumente hoch. Alle Dokumente sollten klar und lesbar sein.';

  @override
  String get requiredDocumentsMustBe => 'Um fortzufahren, müssen die erforderlichen Dokumente hochgeladen werden.';

  @override
  String get dropYourFilesHereOr => 'Legen Sie Ihre Dateien hier ab oder';
  
  @override
  String get browse => 'Durchsuchen';

  @override
  String get pleaseUploadAllRequired => 'Bitte laden Sie alle erforderlichen Dokumente hoch';
  
  @override
  String get viewPDF => 'PDF anzeigen';

  @override
  String get selectServiceZone => 'Servicezone auswählen';
}