<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Arr;
use App\Models\ServiceAddon;

class ServiceAddonsTableSeeder extends Seeder
{

    /**
     * Auto generated seed file
     *
     * @return void
     */
    public function run()
    {
        

        // \DB::table('service_addons')->delete();
        
        // \DB::table('service_addons')->insert(array (
            $data = [
                [
                'id' => 1,
                'name' => 'Hair Spa',
                'service_id' => 94,
                'price' => 12.0,
                'qty' => 1,
                'status' => 1,
                'serviceaddon_image' => public_path('/images/service_addon/hair_cutting_and_styling/hair_spa.png'),
                'deleted_at' => NULL,
                'created_at' => '2024-02-01 05:39:09',
                'updated_at' => '2024-02-01 05:39:09',
                'created_by' => 1,
            ],
            [
                'id' => 2,
                'name' => 'Hair Wash',
                'service_id' => 94,
                'price' => 10.0,
                'qty' => 1,
                'status' => 1,
                'serviceaddon_image' => public_path('/images/service_addon/hair_cutting_and_styling/hair_wash.png'),
                'deleted_at' => NULL,
                'created_at' => '2024-02-01 05:40:04',
                'updated_at' => '2024-02-01 05:40:04',
                'created_by' => 1,
            ],
            [
                'id' => 3,
                'name' => 'Fondant Artistry Upgrade',
                'service_id' => 105,
                'price' => 10.0,
                'qty' => 1,
                'status' => 1,
                'serviceaddon_image' => public_path('/images/service_addon/custom_cake_creations/fondant_artistry_upgrade.png'),
                'deleted_at' => NULL,
                'created_at' => '2024-02-01 05:47:46',
                'updated_at' => '2024-02-01 05:47:46',
                'created_by' => 1,
            ],
            [
                'id' => 4,
                'name' => 'Flavor Burst Enhancement',
                'service_id' => 105,
                'price' => 12.0,
                'qty' => 1,
                'status' => 1,
                'serviceaddon_image' => public_path('/images/service_addon/custom_cake_creations/flavor_burst_enhancement.png'),
                'deleted_at' => NULL,
                'created_at' => '2024-02-01 05:51:41',
                'updated_at' => '2024-02-01 05:51:41',
                'created_by' => 1,
            ],
            [
                'id' => 5,
                'name' => 'Energy-Efficient Lighting Solutions',
                'service_id' => 106,
                'price' => 8.0,
                'qty' => 1,
                'status' => 1,
                'serviceaddon_image' => public_path('/images/service_addon/electrical_wiring_installation/energy_efficient_lighting_solutions.png'),
                'deleted_at' => NULL,
                'created_at' => '2024-02-01 05:58:07',
                'updated_at' => '2024-02-01 05:58:07',
                'created_by' => 1,
            ],
            [
                'id' => 6,
                'name' => 'Emergency Backup Power Installation',
                'service_id' => 106,
                'price' => 9.0,
                'qty' => 1,
                'status' => 1,
                'serviceaddon_image' => public_path('/images/service_addon/electrical_wiring_installation/emergency_backup_power_installation.png'),
                'deleted_at' => NULL,
                'created_at' => '2024-02-01 06:03:40',
                'updated_at' => '2024-02-01 06:03:40',
                'created_by' => 1,
            ],
            [
                'id' => 7,
                'name' => 'Window Washing',
                'service_id' => 107,
                'price' => 6.0,
                'qty' => 1,
                'status' => 1,
                'serviceaddon_image' => public_path('/images/service_addon/office_cleaning/window_washing.png'),
                'deleted_at' => NULL,
                'created_at' => '2024-02-01 06:08:03',
                'updated_at' => '2024-02-01 06:08:03',
                'created_by' => 1,
            ],
            [
                'id' => 8,
                'name' => 'Green Cleaning',
                'service_id' => 107,
                'price' => 6.0,
                'qty' => 1,
                'status' => 1,
                'serviceaddon_image' => public_path('/images/service_addon/office_cleaning/green_cleaning.png'),
                'deleted_at' => NULL,
                'created_at' => '2024-02-01 06:09:43',
                'updated_at' => '2024-02-01 06:09:43',
                'created_by' => 1,
            ],
            [
                'id' => 9,
                'name' => 'Anti-Corrosion Protection',
                'service_id' => 108,
                'price' => 10.0,
                'qty' => 1,
                'status' => 1,
                'serviceaddon_image' => public_path('/images/service_addon/fixture_installation/anti_corrosion_protection.png'),
                'deleted_at' => NULL,
                'created_at' => '2024-02-01 06:27:16',
                'updated_at' => '2024-02-01 06:27:16',
                'created_by' => 1,
            ],
            [
                'id' => 10,
                'name' => 'Water Efficiency Upgrade',
                'service_id' => 108,
                'price' => 19.0,
                'qty' => 1,
                'status' => 1,
                'serviceaddon_image' => public_path('/images/service_addon/fixture_installation/water_efficiency_upgrade.png'),
                'deleted_at' => NULL,
                'created_at' => '2024-02-01 06:29:51',
                'updated_at' => '2024-02-01 06:29:51',
                'created_by' => 1,
            ],
            [
                'id' => 11,
                'name' => 'Electronic Device Sanitization',
                'service_id' => 109,
                'price' => 13.0,
                'qty' => 1,
                'status' => 1,
                'serviceaddon_image' => public_path('/images/service_addon/full_home_sanitization/electronic_device_sanitization.png'),
                'deleted_at' => NULL,
                'created_at' => '2024-02-01 06:52:34',
                'updated_at' => '2024-02-01 06:52:34',
                'created_by' => 1,
            ],
            [
                'id' => 12,
                'name' => 'Upholstery Sterilization',
                'service_id' => 109,
                'price' => 7.0,
                'qty' => 1,
                'status' => 1,
                'serviceaddon_image' => public_path('/images/service_addon/full_home_sanitization/upholstery_sterilization.png'),
                'deleted_at' => NULL,
                'created_at' => '2024-02-01 06:57:56',
                'updated_at' => '2024-02-01 06:57:56',
                'created_by' => 1,
            ],
            [
                'id' => 13,
                'name' => 'Duct Cleaning and Sanitization',
                'service_id' => 110,
                'price' => 20.0,
                'qty' => 1,
                'status' => 1,
                'serviceaddon_image' => public_path('/images/service_addon/filter_replacement/duct_cleaning_and_sanitization.png'),
                'deleted_at' => NULL,
                'created_at' => '2024-02-01 07:03:09',
                'updated_at' => '2024-02-01 07:03:09',
                'created_by' => 1,
            ],
            [
                'id' => 14,
                'name' => 'Energy-Efficient Filter Upgrade',
                'service_id' => 110,
                'price' => 15.0,
                'qty' => 1,
                'status' => 1,
                'serviceaddon_image' => public_path('/images/service_addon/filter_replacement/energy_efficient_filter_upgrade.png'),
                'deleted_at' => NULL,
                'created_at' => '2024-02-01 07:11:06',
                'updated_at' => '2024-02-01 07:11:06',
                'created_by' => 1,
            ],
            [
                'id' => 15,
                'name' => 'Installation of Airflow Boosters',
                'service_id' => 93,
                'price' => 20.0,
                'qty' => 1,
                'status' => 1,
                'serviceaddon_image' => public_path('/images/service_addon/airflow_problem_identification/installation_of_airflow_boosters.png'),
                'deleted_at' => NULL,
                'created_at' => '2024-02-01 07:16:39',
                'updated_at' => '2024-02-01 07:16:39',
                'created_by' => 1,
            ],
            [
                'id' => 16,
                'name' => 'Ventilation System Inspection',
                'service_id' => 93,
                'price' => 15.0,
                'qty' => 1,
                'status' => 1,
                'serviceaddon_image' => public_path('/images/service_addon/airflow_problem_identification/ventilation_system_inspection.png'),
                'deleted_at' => NULL,
                'created_at' => '2024-02-01 07:17:47',
                'updated_at' => '2024-02-01 07:17:47',
                'created_by' => 1,
            ],
            [
                'id' => 17,
                'name' => 'Face Moisturizing & Mask Treatment',
                'service_id' => 96,
                'price' => 22.0,
                'qty' => 1,
                'status' => 1,
                'serviceaddon_image' => public_path('/images/service_addon/manicure_pedicure/face_moisturizing_mask_treatment.png'),
                'deleted_at' => NULL,
                'created_at' => '2024-02-01 07:29:29',
                'updated_at' => '2024-02-01 07:29:29',
                'created_by' => 1,
            ],
            [
                'id' => 18,
                'name' => 'Gel Nail Polish',
                'service_id' => 96,
                'price' => 10.0,
                'qty' => 1,
                'status' => 1,
                'serviceaddon_image' => public_path('/images/service_addon/manicure_pedicure/gel_nail_polish.png'),
                'deleted_at' => NULL,
                'created_at' => '2024-02-01 07:31:11',
                'updated_at' => '2024-02-01 07:31:11',
                'created_by' => 1,
            ],
            [
                'id' => 19,
                'name' => 'Condenser Coil Cleaning',
                'service_id' => 97,
                'price' => 24.0,
                'qty' => 1,
                'status' => 1,
                'serviceaddon_image' => public_path('/images/service_addon/compressor_fix/condenser_coil_cleaning.png'),
                'deleted_at' => NULL,
                'created_at' => '2024-02-01 07:38:21',
                'updated_at' => '2024-02-01 07:38:21',
                'created_by' => 1,
            ],
            [
                'id' => 20,
                'name' => 'Thermostat Calibration',
                'service_id' => 97,
                'price' => 16.0,
                'qty' => 1,
                'status' => 1,
                'serviceaddon_image' => public_path('/images/service_addon/compressor_fix/thermostat_calibration.png'),
                'deleted_at' => NULL,
                'created_at' => '2024-02-01 07:39:57',
                'updated_at' => '2024-02-01 07:39:57',
                'created_by' => 1,
            ],
            [
                'id' => 21,
                'name' => 'Surge Protector Installation',
                'service_id' => 99,
                'price' => 14.0,
                'qty' => 1,
                'status' => 1,
                'serviceaddon_image' => public_path('/images/service_addon/circuit_repair/surge_protector_installation.png'),
                'deleted_at' => NULL,
                'created_at' => '2024-02-01 07:43:25',
                'updated_at' => '2024-02-01 07:43:25',
                'created_by' => 1,
            ],
            [
                'id' => 22,
                'name' => 'Ground Fault Circuit Interrupter Outlet Installation',
                'service_id' => 99,
                'price' => 16.0,
                'qty' => 1,
                'status' => 1,
                'serviceaddon_image' => public_path('/images/service_addon/circuit_repair/ground_fault_circuit_interrupter_outlet_installation.png'),
                'deleted_at' => NULL,
                'created_at' => '2024-02-01 07:46:29',
                'updated_at' => '2024-02-01 07:46:29',
                'created_by' => 1,
            ],
            [
                'id' => 23,
                'name' => 'Pressed Flowers Frame',
                'service_id' => 100,
                'price' => 12.0,
                'qty' => 1,
                'status' => 1,
                'serviceaddon_image' => public_path('/images/service_addon/artistic_frame_designer/pressed_flowers_frame.png'),
                'deleted_at' => NULL,
                'created_at' => '2024-02-01 07:58:22',
                'updated_at' => '2024-02-01 07:58:22',
                'created_by' => 1,
            ],
            [
                'id' => 24,
                'name' => 'Artwork Cleaning and Restoration',
                'service_id' => 100,
                'price' => 10.0,
                'qty' => 1,
                'status' => 1,
                'serviceaddon_image' => public_path('/images/service_addon/artistic_frame_designer/artwork_cleaning_and_restoration.png'),
                'deleted_at' => NULL,
                'created_at' => '2024-02-01 08:02:38',
                'updated_at' => '2024-02-01 08:02:38',
                'created_by' => 1,
            ],
            [
                'id' => 25,
                'name' => 'Custom Stitching',
                'service_id' => 104,
                'price' => 29.0,
                'qty' => 1,
                'status' => 1,
                'serviceaddon_image' => public_path('/images/service_addon/seam_repair_reinforcement/custom_stitching.png'),
                'deleted_at' => NULL,
                'created_at' => '2024-02-01 08:12:15',
                'updated_at' => '2024-02-01 08:12:15',
                'created_by' => 1,
            ],
            [
                'id' => 26,
                'name' => 'Anti-Wrinkle Finish',
                'service_id' => 104,
                'price' => 30.0,
                'qty' => 1,
                'status' => 1,
                'serviceaddon_image' => public_path('/images/service_addon/seam_repair_reinforcement/anti_wrinkle_finish.png'),
                'deleted_at' => NULL,
                'created_at' => '2024-02-01 08:13:44',
                'updated_at' => '2024-02-01 08:13:44',
                'created_by' => 1,
            ],
        ];
        
        foreach ($data as $key => $val) {
            $featureImage = $val['serviceaddon_image'] ?? null;
            $serviceaddonData = Arr::except($val, ['serviceaddon_image']);
            $serviceaddon = ServiceAddon::create($serviceaddonData);
            if (isset($featureImage)) {
                $this->attachFeatureImage($serviceaddon, $featureImage);
            }
        }
    }

    private function attachFeatureImage($model, $publicPath)
    {

        $file = new \Illuminate\Http\File($publicPath);

        $media = $model->addMedia($file)->preservingOriginal()->toMediaCollection('serviceaddon_image');

        return $media;

    }
}